'''
simLib
========================
Zeitreihen-Generator für stochastisch modellierte Batch-Prozesse

(c) 2024:  Prof. Dr. Jürgen Bechtloff, Meschede
--------------------------------------------------------------------


'''
import PT1lib
import numpy as np


class Proz():
    def __init__(self,cfg,T):
        self.x = np.array(cfg["x"])
        self.xSig = np.array(cfg["xSig"])
        self.w = cfg["w"]
        self.pt1 = PT1lib.PT1(T=T, T1=cfg["T1"])
        self.xz = self.x
        self.name = cfg.name

    def prep(self):
        for k in range(len(self.x)):
            self.xz[k] = self.x[k] + np.random.normal(scale=self.xSig[k])


class BatchProz():
    def __init__(self,cfg, T):
        self.dt = np.array(cfg["dt"])
        self.tSig = np.array(cfg["tSig"])
        self.T = T  # Abstastzeit
        self.t0 = 0 # batch-Zeit
        self.tG = 0 # Zeit seit Start
        self.cntG = 0 # ZyklenCount seit Start
        self.tz = np.copy(self.dt)
        self.xLst = []
        for b in cfg.bat:
            self.xLst.append(Proz(b,T))
        self.m = len(self.dt)-1
        self.prep()

    def prep(self):
        self.tz[0] = 0
        for k in range(1,self.m+1):
            # Zeitdauern werden aufaddiert
            self.tz[k] = self.tz[k-1] + self.dt[k] + np.absolute(np.random.normal(scale=self.tSig[k]))
        self.t0 = 0
        self.tGes = self.tz[self.m]
        for b in self.xLst:
            b.prep()
    
    def genTS(self):
        self.t0 += self.T
        self.tG += self.T
        if self.t0 > self.tGes: 
            self.t0 = 0
            self.cntG += 1
            self.prep()

        y = []
        for b in self.xLst:
            y.append(b.pt1.PT1rek_s(np.interp(self.t0, self.tz, b.xz)) + np.random.normal(scale=b.w))

        return self.t0,self.tG,self.cntG, y
