
'''
Prozess-Simulation  ** Realtime -> mqtt
===============================

+ class-Lib

zmq -> send_json

'''
import simLib_01 as simLib
import zmq
import numpy as np
from datetime import datetime
import time
from benedict import benedict
import json


from apscheduler.schedulers.background import BackgroundScheduler

# 0MQ-Server Definition
context = zmq.Context()
socket = context.socket(zmq.REP)
socket.bind("tcp://*:5555")


# ------------------------------------------------------------------
cfg = benedict.from_toml('cfg.toml', keyattr_dynamic=True)

# ------------------------------------------------------------------

# ------------------------------------------------------------------
class SimProz():

    def __init__(self,bProz) -> None:
        self.PL = {}
        self.bProz = bProz

    def sim(self):
        t0, tG, cntG, y0 = self.bProz.genTS()
        ts = datetime.now()
        print(f'ts= {ts},  cnt={cntG}  y= {y0}')

        self.PL =    {"ts": str(ts),   # utf-Zeit
                "cnt": cntG,
                }
        for i, p in zip(range(self.bProz.m-1), self.bProz.xLst):
            self.PL.update({p.name: y0[i]})


    def serv(self):
        message = socket.recv()
        print(f"Received request: {message}")
        socket.send_json(self.PL)
        # time.sleep(0.1)
    
# ------------------------------------------------------------------


cfg_sim = benedict.from_toml('prz_01.toml', keyattr_dynamic=True)

bProz = simLib.BatchProz(cfg_sim, cfg_sim.T)
bProz.prep()

simProz = SimProz(bProz)

sched = BackgroundScheduler({'apscheduler.timezone': 'UTC'})
sched.add_job(simProz.sim, 'interval', seconds=cfg_sim.T, id='runJob1')
sched.start()


while True:
    simProz.serv()