
'''
Prozess-Simulation  ** Realtime -> RESTapi
=========================================
(c) 2024 Dr. Jürgen Bechtloff, Meschede
---------------------------------------

Endpoints:
/meta  -> liefert eine Liste der Sim-Größen mit Meta-Daten
/data  -> liefert ein Array der Sim-Values

'''
import simLib_01 as simLib
from datetime import datetime
from benedict import benedict
import json

import uvicorn
from fastapi import FastAPI

from dataclasses import dataclass

from apscheduler.schedulers.background import BackgroundScheduler


app = FastAPI()



# ------------------------------------------------------------------
cfg = benedict.from_toml('cfg.toml', keyattr_dynamic=True)

# ------------------------------------------------------------------

# ------------------------------------------------------------------
class SimProz():

    def __init__(self,bProz) -> None:
        self.PL = {}
        self.bProz = bProz

    def sim(self):
        t0, tG, cntG, y0 = self.bProz.genTS()
        ts = datetime.now()
        print(f'ts= {ts},  cnt={cntG}  y= {y0}')

        self.PL =    {"ts": str(ts),   # utf-Zeit
                "cnt": cntG,
                }
        for i, p in zip(range(self.bProz.m-1), self.bProz.xLst):
            self.PL.update({p.name: y0[i]})


# ------------------------------------------------------------------
@app.get("/data")
def read_data():
    return json.dumps(simProz.PL)

# ------------------------------------------------------------------
@app.get("/meta")
def read_meta():
    print(cfg_sim.bat)
    meta = []
    for b in cfg_sim.bat:
        meta.append({'name':b.name, 'meta':b.meta})
    return json.dumps(meta)

# ------------------------------------------------------------------

if __name__ == "__main__":
    cfg_sim = benedict.from_toml(cfg.sim_cfg, keyattr_dynamic=True)

    bProz = simLib.BatchProz(cfg_sim, cfg_sim.T)
    bProz.prep()

    simProz = SimProz(bProz)

    sched = BackgroundScheduler({'apscheduler.timezone': 'UTC'})
    sched.add_job(simProz.sim, 'interval', seconds=cfg_sim.T, id='runJob1')
    sched.start()

    uvicorn.run(app, host=cfg.RESTapi.ip, port=cfg.RESTapi.port)
