
'''
Prozess-Simulation ** Realtime
===============================
OpcUa-Server
-----------------------------------------------
(c) 2024:  Prof. Dr. Jürgen Bechtloff, Meschede
-----------------------------------------------
v0.2 / 01.03.2024
    - Problem mit Debug-Mode

'''
import simLib_01 as simLib
from asyncua.sync import Server, ua
from datetime import datetime
import time
from benedict import benedict
from apscheduler.schedulers.background import BackgroundScheduler

# ------------------------------------------------------------------
cfg = benedict.from_toml('cfg.toml', keyattr_dynamic=True)
# ------------------------------------------------------------------

class SimProz():

    def __init__(self,bProz):
        self.bProz = bProz
        # setup our server
        server = Server()
        server.set_endpoint(f"opc.tcp://{cfg.opcua.ip}:{cfg.opcua.port}/freeopcua/server/")

        # setup namespace (not really necessary but should as spec)
        uri = "http://examples.freeopcua.github.io"
        self.idx = server.register_namespace(uri)
        # address space
        self.simProzObj = server.nodes.objects.add_object(self.idx, "simProz")
        self.uaVar_ts  = self.simProzObj.add_variable(ua.NodeId.from_string(f'ns={self.idx};s=ts'),'ts','')
        self.uaVar_cnt = self.simProzObj.add_variable(ua.NodeId.from_string(f'ns={self.idx};s=cnt'),'cnt',0)            
        self.uaVarLst = []
        for p in self.bProz.xLst:
            s = f'ns={self.idx};s={p.name}'
            self.uaVarLst.append(self.simProzObj.add_variable(ua.NodeId.from_string(s),p.name,0.0))            
        server.start()

    def run(self):
        t0, tG, cntG, y0 = self.bProz.genTS()
        ts = datetime.now()
        print(f'ts= {ts},  cnt={cntG}  y= {y0}')

        self.uaVar_ts.write_value(ts.isoformat())
        self.uaVar_cnt.write_value(cntG)

        for i, mv in zip(range(self.bProz.m-1),self.uaVarLst):
            mv.write_value(y0[i])

# ------------------------------------------------------------------


cfg_sim = benedict.from_toml('prz_01.toml', keyattr_dynamic=True)

bProz = simLib.BatchProz(cfg_sim, cfg_sim.T)

simProz = SimProz(bProz)

sched = BackgroundScheduler({'apscheduler.timezone': 'UTC'})
sched.add_job(simProz.run, 'interval', seconds=cfg_sim.T, id='runJob1')
sched.start()


while True:
    time.sleep(1)
