
'''
Prozess-Simulation ** Realtime
===============================
MQTT-Publisher
-----------------------------------------------
(c) 2024:  Prof. Dr. Jürgen Bechtloff, Meschede
-----------------------------------------------
v0.2 / 01.03.2024

'''
import numpy as np
from datetime import datetime
from benedict import benedict
import json

from apscheduler.schedulers.blocking import BlockingScheduler
import paho.mqtt.client as mqtt

import simLib_01 as simLib

# ------------------------------------------------------------------
cfg = benedict.from_toml('cfg.toml', keyattr_dynamic=True)
mq_topic = "test_172"
# ------------------------------------------------------------------
# MQTT-Publisher
def on_connect(client, userdata, flags, rc):
    print("Connected with result code " + str(rc))



def simProz():
    t0, tG, cntG, y0 = bProz.genTS() 
    ts = datetime.now()     # timestamp
    print( f'ts= {ts},    y= {y0}')            

    PL = {"ts": str(ts),   # utf-Zeit
            "cnt": cntG,
        }
    for i, p in zip(range(bProz.m-1), bProz.xLst):
        PL.update({p.name : y0[i]})
    # Umwandeln in EIN json-Objekt
    jPL = json.dumps(PL)
    # versenden (publish)
    mq_client.publish(topic=mq_topic, payload = jPL )

# ------------------------------------------------------------------

cfg_sim = benedict.from_toml('prz_01.toml', keyattr_dynamic=True)

bProz = simLib.BatchProz(cfg_sim,cfg_sim.T)
# bProz.prep()

sched = BlockingScheduler({'apscheduler.timezone': 'UTC'})
sched.add_job(simProz,'interval', seconds=cfg_sim.T, id='runJob1') 


mq_client = mqtt.Client()
mq_client.on_connect = on_connect
mq_client.connect(cfg.mqtt.ip, 1883, 60)
mq_client.loop_start()



try:
    sched.start()
except (KeyboardInterrupt, SystemExit):
    pass 



