
'''
Prozess-Simulation  ** Realtime -> MongoDB
===============================================
(c) 2024 Dr. Jürgen Bechtloff, Meschede
---------------------------------------
+ class-Lib


'''
import simLib_01 as simLib

from pymongo import MongoClient

import numpy as np
from datetime import datetime, timedelta
import time
from benedict import benedict
import json

import os
from apscheduler.schedulers.blocking import BlockingScheduler

# ------------------------------------------------------------------
# Konfiguration lesen
cfg = benedict.from_toml('cfg.toml', keyattr_dynamic=True)
cfg_sim = benedict.from_toml(cfg.sim_cfg, keyattr_dynamic=True)
# ------------------------------------------------------------------

# ------------------------------------------------------------------
class SimProz():

    def __init__(self,bProz) -> None:
        self.PL = {'ts':datetime.now(), 'cnt':0}
        self.bProz = bProz

    def sim(self):
        t0, tG, cntG, y0 = self.bProz.genTS()
        ts = datetime.now()
        print(f'ts= {ts},  cnt={cntG}  y= {y0}')

        self.PL =   {"ts": ts,   # utf-Zeit
                     "cnt": cntG,
                    }
        for i, p in zip(range(self.bProz.m-1), self.bProz.xLst):
            self.PL.update({p.name: y0[i]})

    def init_mdb(self,cfg):
        client = MongoClient(cfg.ip, cfg.port)
        mdb = client[cfg.db]
        self.col = mdb[cfg.col]
        self.col.drop()  # Alte Collection LÖSCHEN !!!

        try:
            mdb.create_collection(
                self.col,
                timeseries={
                    "timeField": "ts",
                    "metaField": "loc",
                    "granularity": "seconds"
                },
                # expireAfterSeconds = 4 * 7 * 24 * 60 * 60 # Ablauf der Gültigkeit von Datensätzen (damit die DB nicht unendlich wächst..)  -> CFG
                expireAfterSeconds = cfg.expire  # Ablauf der Gültigkeit von Datensätzen (damit die DB nicht unendlich wächst..)  -> CFG
            )
        # except mdbErrors.OperationFailure:  # If the collection doesn't exist
        except:  # If the collection doesn't exist
            print("This collection doesn't exist")        

    def write_mdb(self, ts):
        self.sim()
        self.PL["ts"] = ts
        result = self.col.insert_one(self.PL)

    def write_mdb_now(self):
        self.sim()
        result = self.col.insert_one(self.PL)
    
# ------------------------------------------------------------------
# ------------------------------------------------------------------


bProz = simLib.BatchProz(cfg_sim, cfg_sim.T)
bProz.prep()

simProz = SimProz(bProz)
simProz.init_mdb(cfg.mdb)

# ------------------------------------------------------------------
# Vorlauf der Simulation == Historie
tsE = datetime.now()  # now
tsA = tsE - timedelta(weeks=cfg.historie.weeks, days=cfg.historie.days , minutes=cfg.historie.minutes, hours=cfg.historie.hours, seconds=cfg.historie.seconds)  # Vorlauf der Simulation

ts = tsA
while ts <= tsE: 
    simProz.write_mdb(ts)
    ts = ts + timedelta(seconds=cfg_sim.T)
    print(ts)


# ------------------------------------------------------------------
# Start der zyklischen Simulation
sched = BlockingScheduler({'apscheduler.timezone': 'UTC'})
sched.add_job(simProz.write_mdb_now, 'interval', seconds=cfg_sim.T, id='run_mdbwrite')

print('Press Ctrl+{0} to exit'.format('Break' if os.name == 'nt' else 'C'))

try:
    sched.start()
except (KeyboardInterrupt, SystemExit):
    pass                
