
'''
Prozess-Simulation  ** Realtime -> InfluxDB
===============================================
(c) 2024 Dr. Jürgen Bechtloff, Meschede
---------------------------------------



'''
import simLib_01 as simLib

# ========================================================================
from influxdb_client import InfluxDBClient, Point, WritePrecision, WriteOptions, BucketRetentionRules
from influxdb_client.client.write_api import SYNCHRONOUS


# ========================================================================

import numpy as np
from datetime import datetime, timedelta, timezone 
import time
from benedict import benedict
import json

import os
from apscheduler.schedulers.blocking import BlockingScheduler

# ------------------------------------------------------------------
# Konfiguration lesen
cfg = benedict.from_toml('cfg.toml', keyattr_dynamic=True)
cfg_sim = benedict.from_toml(cfg.sim_cfg, keyattr_dynamic=True)
# ------------------------------------------------------------------
# ------------------------------------------------------------------
class SimProz():

    def __init__(self,bProz) -> None:
        self.PL = {'cnt':0}
        self.bProz = bProz
        self.ts = datetime.now(timezone.utc) # influxDB !!!

    def sim(self):
        t0, tG, cntG, y0 = self.bProz.genTS()
        self.ts = datetime.now(timezone.utc) # influxDB !!!
        print(f'ts= {self.ts},  cnt={cntG}  y= {y0}')

        self.PL =   {"cnt": cntG}
        for i, p in zip(range(self.bProz.m-1), self.bProz.xLst):
            self.PL.update({p.name: y0[i]})

    def init_idb(self,cfg):
        client = InfluxDBClient(url=f'http://{cfg.ip}:{cfg.port}', token=cfg.token, org=cfg.org)

        self.wapi = client.write_api(write_options=WriteOptions(batch_size=1))
        self.buc = cfg.buc
        self.mes = cfg.mes
        buckets_api = client.buckets_api()
        # wenn die Datenbank noch vorhanden ist, dann wird sie erzeugt:
        if buckets_api.find_bucket_by_name(self.buc) == None:
            print(f"Bucket {self.buc} nicht da")
            retention_rules = BucketRetentionRules(type="expire", every_seconds=cfg.expire)
            created_bucket = buckets_api.create_bucket(bucket_name=buc,
                                                        retention_rules=retention_rules,
                                                        org=org)

    def write_idb(self, ts):
        self.sim()
        dat = {
            "measurement": self.mes,
            "tags": {},
            "time": ts,
            "fields": self.PL
        }
        self.wapi.write(bucket=self.buc, record=dat, write_precision='ms')

    def write_idb_now(self):
        self.sim()
        dat = {
            "measurement": self.mes,
            "tags": {"loc": "host3"},
            "time": self.ts,
            "fields": self.PL
        }
        self.wapi.write(bucket=self.buc, record=dat, write_precision='ms')
# ------------------------------------------------------------------
# ------------------------------------------------------------------


bProz = simLib.BatchProz(cfg_sim, cfg_sim.T)
bProz.prep()

simProz = SimProz(bProz)
simProz.init_idb(cfg=cfg.idb)

# ------------------------------------------------------------------
# Vorlauf der Simulation == Historie
tsE = datetime.now(timezone.utc)  # now ((influxDB utc))
tsA = tsE - timedelta(weeks=cfg.historie.weeks, days=cfg.historie.days , minutes=cfg.historie.minutes, hours=cfg.historie.hours, seconds=cfg.historie.seconds)  # Vorlauf der Simulation

ts = tsA
while ts <= tsE: 
    simProz.write_idb(ts)
    ts = ts + timedelta(seconds=cfg_sim.T)
    print(ts)


# ------------------------------------------------------------------
# Start der zyklischen Simulation
sched = BlockingScheduler({'apscheduler.timezone': 'UTC'})
sched.add_job(simProz.write_idb_now, 'interval', seconds=cfg_sim.T, id='run_idbwrite')

print('Press Ctrl+{0} to exit'.format('Break' if os.name == 'nt' else 'C'))

try:
    sched.start()
except (KeyboardInterrupt, SystemExit):
    pass                
