
'''
Prozess-Simulation
==================
Plot-Ausgabe in einem matplotlib-Fenster
---------------------------------------------
(c) 2024:  Prof. Dr. Jürgen Bechtloff, Meschede
'''
import numpy as np
from benedict import benedict
import matplotlib.pyplot as plt

import simLib_01 as simLib


# Einlesen der toml-Konfigurationsdatei
d = benedict.from_toml('prz_2plt.toml', keyattr_dynamic=True)

# sim-Instanz
bProz = simLib.BatchProz(cfg=d,T=1)
N = 500  # Anzahl der Plot-Punkte

tpl = np.zeros(N)
cntGpl = np.zeros(N)
ypl = []
cnt_km1 = 0
# Generierung der Zeitreihen -----------------------------
for k in range(N):
    t0, tG, cntG, y = bProz.genTS() 
    tpl[k]=tG
    cntGpl[k] = (1 if cntG>cnt_km1 else 0)  # Peek-Signal für Zyklusende/-anfang
    cnt_km1=cntG
    # Datenmatrix belegen
    ypl = np.hstack((ypl,y))

m = len(bProz.xLst)

# Plot-Ausgabe --------------------------------------------
fig, axs = plt.subplots(m, 1, layout='constrained')

y = ypl.reshape(N,m).T
for i, b in zip(range(m), bProz.xLst):
    axs[i].plot(tpl, y[i])
    axs[i].plot(tpl, cntGpl*y[i].max())
    axs[i].set_xlabel('t')
    axs[i].set_ylabel(b.name)
    axs[i].grid(True)

plt.show()

